﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Catalogue
{
    public partial class Observation : Form
    {
        public Observation()
        {
            InitializeComponent();
        }

        private void Observation_Load(object sender, EventArgs e)
        {

            lblNomMedicament1.Text = FamilleMedicament.medicamentSelectionne;

            cboPraticien.DataSource = Métiers.Observation.praticiens();
            cboPraticien.DisplayMember= Métiers.Observation.praticiens().Columns[0].ToString();

            //Changement libelle
            lblFamille.Text = Accueil.famille;
            lblGroupe.Text = Accueil.groupe;
            lblNomMedicament2.Text = FamilleMedicament.medicamentSelectionne;

            //Affichage image du médicament
            picMedicament.Image = Image.FromFile("C:\\Users\\dorian balducci\\source\\repos\\Piscine\\img\\" + Métiers.Medicament.medicament(FamilleMedicament.medicamentSelectionne).Rows[0]["mDepotLegal"].ToString() + ".jpg");
            picMedicament.SizeMode = PictureBoxSizeMode.StretchImage;

            if (Accueil.etatBoutonOkRecherche == true) //si c'est un médicament sélectionné depuis la barre de recherche direct (si le bouton ok est appuyé)
            {
                lblGroupe.Text=Métiers.Medicament.groupeFamilleMedicament(Accueil.nomMedicament).Rows[0][0].ToString();
                lblFamille.Text = Métiers.Medicament.groupeFamilleMedicament(Accueil.nomMedicament).Rows[0][1].ToString();
                lblNomMedicament2.Text = Accueil.nomMedicament;

                //Affichage image du médicament
                picMedicament.Image = Image.FromFile("C:\\Users\\dorian balducci\\source\\repos\\Piscine\\img\\" + Métiers.Medicament.medicament(Accueil.nomMedicament).Rows[0]["mDepotLegal"].ToString() + ".jpg");
                picMedicament.SizeMode = PictureBoxSizeMode.StretchImage;
                
                Accueil.etatBoutonOkRecherche = false;
            }

            if (rtbRemarque.Text == "")
            {
                btnValider.Visible = false;
            }
            
        }

        private void btnAccueil_Click(object sender, EventArgs e)
        {
            Accueil.fermerAccueil = true;
            this.Close();
        }

        private void btnRetour_Click(object sender, EventArgs e)
        {
            Accueil.fermerAccueil = false;
            this.Close();
        }

        private void rtbRemarque_TextChanged(object sender, EventArgs e)
        {
            if (rtbRemarque.Text != "")
            {
                btnRetour.Visible = false;
                btnValider.Visible = true;
            }
            else
                btnValider.Visible = false;

        }

        private void btnReset_Click(object sender, EventArgs e)
        {
            rtbRemarque.Text = "";
            cboPraticien.SelectedIndex = 0;

            btnRetour.Visible = true;
        }

        private void btnValider_Click(object sender, EventArgs e)
        {
            int oNum = Convert.ToInt32(Métiers.Observation.oNum().Rows[0]["oNum"]);

            string pNomPrenom = cboPraticien.Text;
            Métiers.Observation.praticiens();
            int pNum = Convert.ToInt32(Métiers.Observation.pNumPraticiens(pNomPrenom).Rows[0]["pNum"]);
            string oRemarque = rtbRemarque.Text;
            string mDepotLegal = Medicament.depotLegal;

            Métiers.Observation.nouvelleObservation(oNum,pNum,oRemarque,mDepotLegal);

            rtbRemarque.Text = "";
            cboPraticien.SelectedIndex = 0;

            btnRetour.Visible = true;

            MessageBox.Show("Remarque bien ajoutée !");
			
			this.Close();
        }

    }
}
